<?php
	header('Access-Control-Allow-Origin: *');
	header('Content-type: application/json');
	require_once 'include/class.user.php';
	$user_home = new USER();

	if (!empty($_GET["action"])) {
		$action = $_GET["action"];
		switch ($action) {
			case 'setValues':
				$post = $_POST;
				$token = '';
				$language = '';

				if (!empty($_POST['token'])) {
					$token = $_POST['token'];
				}
				if (!empty($_POST['lang'])) {
					$language = $_POST['lang'];
					include('language/' . $language . '.php');
				} else {
					include('language/en.php');
				}
				
				array_splice($post, 0, 1);
				array_splice($post, 0, 1);
				$keys = array();
				$v_values = array();
				$i = 0;
				foreach($post as $key=>$value) {
					if ((empty($value)) and ($value != 0)) {
						$return["status"] = "error";
						$return["data"] = $lang['missing_parameter'];
						echo json_encode($return);
						return;
					} else {
						if ($i == 0) {
							$keys[$i] = "game_id";
							$v_values[$i] = "'" . $_POST['gameId'] . "'";
						} else if ($i == 1) {
							$keys[$i] = "user_id";
							$v_values[$i] = "'" . $_POST['userId'] . "'";
						} else {
							$keys[$i] = $key;
							$v_values[$i] = "'" . $value . "'";
						}
						$i++;
					}
				}
				if (empty($_POST['gameId']) || empty($_POST['userId']) || empty($token) || empty($language)) {
                    $return["status"] = "error";
					$return["data"] = $lang['missing_parameter'];
					echo json_encode($return);
					return;
				} else {
					try {
						$keys_str = implode(", ", $keys);
						$values_str = implode(", ", $v_values);
						$sqll = "INSERT INTO ". $token ."_variables($keys_str) VALUES($values_str)";
						if ($stmt = $user_home->prepareQuery($sqll)) {
							if ($stmt->execute()) {
								$return["status"] = "success";
								$return["data"] = $lang['add_variable_success'];
							} else {
								$return["status"] = "error";
								$return["data"] = $lang['database_error'];
							}
						} else {
							$return["status"] = "error";
							$return["data"] = $lang['database_error'];
						}
					} catch (Exception $e) {
						if (strpos($e->getMessage(), 'Duplicate') !== false) {
							$gameId = $v_values[0];
							$userId = $v_values[1];
							array_splice($keys, 0, 1);
							array_splice($v_values, 0, 1);
							array_splice($keys, 0, 1);
							array_splice($v_values, 0, 1);
							try {
								$length = count($keys);
								$sqll = "UPDATE ". $token ."_variables Set ";
								for ($n = 0; $n < $length; $n++) {
									if ($n != ($length-1)) {
										$sqll .= $keys[$n] . "=" . $v_values[$n] . ", ";
									} else {
										$sqll .= $keys[$n] . "=" . $v_values[$n] . "";
									}
								}
								$sqll .= " WHERE user_id=$userId";
								if ($stmt = $user_home->prepareQuery($sqll)) {
									if ($stmt->execute()) {
										$return["status"] = "success";
										$return["data"] = $lang['edit_variable_success'];
									} else {
										$return["status"] = "error";
										$return["data"] = $lang['database_error'];
									}
								} else {
									$return["status"] = "error";
									$return["data"] = $lang['database_error'];
								}
							} catch (Exception $e) {
								$return["status"] = "error";
								$return["data"] = $e->getMessage();
							}
						} else {
							$return["status"] = "error";
							$return["data"] = $lang['database_error'];
						}
					}
					echo json_encode($return);
				}
				
				break;
		}
	}
	
	function record_exists ($table, $column1, $value1, $column2, $value2) {
		$user_home = new USER();
		$stmt = $user_home->prepareQuery("SELECT * FROM $table WHERE $column1=? AND $column2=?");
		$stmt->bind_param('si', $value1, $value2);
		$stmt->execute();
		$stmt->store_result();
		$stmt->fetch();
		if ($stmt->num_rows > 0) {
			return true;
		} else {
			return false;
		}
	}
?>