﻿<?php
	include_once('header.php');
	if ((!empty($_GET['token'])) and (!empty($_GET['id']))) {
		$token = $_GET['token'];
		$game_id = $_GET['id'];
	} else {
		$user_home->redirect('games.php');
	}
	
	$message = "";
	$alert = "";
	
	if (!empty($_POST['action'])) {
		$action = $_POST['action'];
		if ($action == "add") {
			$keys = array();
			$v_values = array();
			$v = 0;
			foreach($_POST as $key=>$value) {
				if ((empty($value)) and ($value != 0)) {
					$message = $lang['fill_all_data'];
					$alert = "alert alert-danger";
				} else {
					if ($v != 0) {
						$keys[$v] = $key;
						$v_values[$v] = "'" . $value . "'";
					} else {
						$keys[$v] = "game_id";
						$v_values[$v] = "'" . $game_id . "'";
					}
					$v++;
				}
			}
			try {
				$keys_str = implode(", ", $keys);
				$values_str = implode(", ", $v_values);
				$sqll = "INSERT INTO ". $token ."_variables($keys_str) VALUES($values_str)";
				if ($stmt = $user_home->prepareQuery($sqll)) {
					if ($stmt->execute()) {
						$message = $lang['add_value_success'];
						$alert = "alert alert-success";
					} else {
						$message = $lang['database_error'];
						$alert = "alert alert-danger";
					}
				} else {
					$message = $lang['database_error'];
					$alert = "alert alert-danger";
				}
			} catch (Exception $e) {
				if (strpos($e->getMessage(), 'Duplicate') !== false) {
					$message = $lang['duplicate_value_error'];
				} else {
					$message = $lang['database_error'];
				}
				$alert = "alert alert-danger";
			}
		}
	}
	
	$sql1 = "SELECT id, name FROM games WHERE token= ?";
	
	if ($stmt = $user_home->prepareQuery($sql1)) {
		$stmt->bind_param('s', $_GET['token']);
		$stmt->execute();

		$stmt->store_result();
		$stmt->bind_result($gameId, $gameName);
		$stmt->fetch();
		$stmt->free_result();
	}
	
	$fields = array();
	$types = array();
	
	if ($stmt = $user_home->runQuery("SHOW COLUMNS FROM " . $token . "_variables")) {
		$i = 0;
		while ($row = $stmt->fetch_array(MYSQLI_ASSOC)) {
			$fields[$i] = $row['Field'];
			$types[$i] = $row['Type'];
			$i++;
		}
	}
	
	$data = [];
	
	if ($stmt = $user_home->runQuery("SELECT * FROM " . $token . "_variables")) {
		while ($row = $stmt->fetch_array(MYSQLI_ASSOC)) {
			$data[] = $row;
		}
	}
?>
	<div id="message" <?= ($message == '' ? 'style="display:none"' : ''); ?>>
		<div class="<?= $alert; ?> alert-dismissible fade show" role="alert" id="alert">
			<?= $message; ?>
			<button type="button" class="close" data-dismiss="alert" aria-label="<?= $lang['close']; ?>">
				<span aria-hidden="true">&times;</span>
			</button>
		</div>
	</div>
<nav aria-label="breadcrumb">
	<ol class="breadcrumb">
		<li class="breadcrumb-item"><a href="index.php"><?= $lang['dashboard']; ?></a></li>
		<li class="breadcrumb-item"><a href="games.php"><?= $lang['games']; ?></a></li>
		<li class="breadcrumb-item active" aria-current="page"><?= sprintf($lang['manage_values_title'], $gameName); ?></li>
	</ol>
</nav>
      <div class="row">
			<div class="col-12">
				<div class="widget widget-table">
					<div class="widget-header"> <i class="fas fa-database"></i>
						<h3> <?= sprintf($lang['manage_values_title'], $gameName); ?></h3>
						<button type="button" onclick="document.querySelector('#addvalue').scrollIntoView({ behavior: 'smooth' });" class="btn btn-success btn-sm"><i class="fas fa-plus-circle"></i>&nbsp;<?= $lang['add_value']; ?></button>
						<a href="variables.php?token=<?= $token; ?>#addvariable" class="btn btn-success btn-sm" style="margin: 0 3px;"><i class="fas fa-plus-circle"></i>&nbsp;<?= $lang['add_variable']; ?></a>
					</div>
					<div class="widget-content">
						<table class="table table-striped table-hover" style="overflow-y: hidden">
							<thead class="thead-inverse">
                                <tr>
<?php
		$count = count($fields);
		for ($x = 1; ($x < $count); $x++) {
?>
	<th><?= ($fields[$x]=='user_id' ? $lang['user_id'] : $fields[$x]); ?></th>
<?php } ?>
									<th width="20%"></th>
                                </tr>
							</thead>
							<tbody>
							<?php if(count($data)==0) {
								echo '<tr><td colspan="' . $count . '" id="no_value"><div class="alert alert-danger">'.$lang["no_value"].'</div></td></tr>';
							} ?>
<?php
	$n = 0;
	foreach ($data as $value) {
		echo '<tr id="row_' . $value['user_id'] . '">';
		for ($x = 1; ($x < $count); $x++) {
			$elem_id = $fields[$x] . $n;
			$v_type = "text";
			if (strpos($types[$x], 'int(11)') !== false) {
				$v_type = "number";
			} else if (strpos($types[$x], 'text') !== false) {
				$v_type = "textarea";
			} else if (strpos($types[$x], 'tinyint') !== false) {
				$v_type = "select";
			}
			$variable_txt = $value[$fields[$x]];
			if ($v_type == "select") {
				$variable_txt = ($variable_txt==0 ? 'false' : 'true');
			}
			echo '<td id="' . $elem_id . '">' . $variable_txt . '</td>';
			if ($v_type == "select") {
				echo "
	<script type='text/javascript'>
	$(document).ready(function() {
		var data = {'true': 'True', 'false': 'False'};
		$('#" . $elem_id . "').editable('save.php', {
			indicator : 'Saving…',
			inputcssclass : 'form-control form-control-sm',
			width : '100%',
			height : '20px',
			submitcssclass : 'btn btn-success btn-sm btn-block',
			submitdata  : {lang: \"$language\", token: \"$token\", type: \"$v_type\", column: \"" . $fields[$x] . "\", userId: \"" . $value['user_id'] . "\", oldValue: \"" . $variable_txt . "\"},
			data   : data,
			submit    : 'ذخیره',
			type    : '" . $v_type . "',
			indicator : '<i class=\"fas fa-spinner fa-spin\"></i>',
			tooltip   : '" . $lang['click_for_edit'] . "'
		});
	 });
	</script> 
	";
			} else {
				echo "
	<script type='text/javascript'>
	$(document).ready(function() {
		$('#" . $elem_id . "').editable('save.php', {
			indicator : 'Saving…',
			inputcssclass : 'form-control form-control-sm',
			width : '100%',
			submitcssclass : 'btn btn-success btn-sm btn-block',
			submitdata : {lang: \"$language\", token: \"$token\", type: \"$v_type\", column: \"" . $fields[$x] . "\", userId: \"" . $value['user_id'] . "\", oldValue: \"" . $variable_txt . "\"},
			submit    : 'ذخیره',
			type    : '" . $v_type . "',
			indicator : '<i class=\"fas fa-spinner fa-spin\"></i>',
			tooltip   : '" . $lang['click_for_edit'] . "'
		});
	 });
	</script> 
	";
			}
		}
		$n++;
?>
<td>
<button type="button" class="btn btn-danger btn-sm" id="delete_value_<?= $value['user_id']; ?>"><i class="far fa-trash-alt"></i>&nbsp;&nbsp;<?= $lang['delete']; ?></a>
<script type="text/javascript">
$('#delete_value_<?= $value['user_id']; ?>').on("click", function () {
	$.confirm({
		title: "<?= $lang['delete']; ?> <?= $value['user_id']; ?>!",
		content: "<?= $lang['delete_value_question']; ?>",
		theme: 'bootstrap',
		buttons: {
			Yes: {
				text: "<?= $lang['yes']; ?>",
				btnClass: "btn-blue",
				keys: [
					"enter",
					"shift"
				],
				action: function () {
					delete_value("<?= $value['user_id']; ?>", "<?= $token; ?>");
				}
			},
			Cancel: {
				text: "<?= $lang['cancel']; ?>",
				action: function () {}
			}
		}
	});
});
</script>
</td>
<?php
		echo '</tr>';
	}
?>
							</tbody>
						</table>
					</div>
				</div>
			</div>
	  </div>
	  
      <div class="row">
			<div class="col-12">
				<div class="widget">
					<div class="widget-header"> <i class="fas fa-plus-circle"></i>
						<h3> <?= $lang['add_value']; ?></h3>
					</div>
					<div class="widget-content">
						<form action="" method="POST" id="addvalue">
							<input type="hidden" id="action" name="action" value="add" />
							<div class="row">
<?php
	for ($x = 1; ($x < $count); $x++) {
		$v_type = "text";
		if (strpos($types[$x], 'int(11)') !== false) {
			$v_type = "number";
		} else if (strpos($types[$x], 'text') !== false) {
			$v_type = "textarea";
		} else if (strpos($types[$x], 'tinyint') !== false) {
			$v_type = "select";
		}
		if ($v_type == "textarea") {
			echo '<div class="form-group col-md-4">
				<label for="' . $fields[$x] . '">' . $fields[$x] . '</label>
				<textarea id="' . $fields[$x] . '" class="form-control" name="' . $fields[$x] . '" required></textarea>
			</div>';
		} else if ($v_type == "text") {
			echo '<div class="form-group col-md-4">
				<label for="' . $fields[$x] . '">' . ($fields[$x]=='user_id' ? $lang['user_id'] : $fields[$x]) . '</label>
				<input type="text" id="' . $fields[$x] . '" class="form-control" name="' . $fields[$x] . '" required>
			</div>';
		} else if ($v_type == "number") {
			echo '<div class="form-group col-md-4">
				<label for="' . $fields[$x] . '">' . $fields[$x] . '</label>
				<input type="number" id="' . $fields[$x] . '" class="form-control" name="' . $fields[$x] . '" required>
			</div>';
		} else if ($v_type == "select") {
			echo '<div class="form-group col-md-4">
				<label for="' . $fields[$x] . '">' . $fields[$x] . '</label>
				<select name="' . $fields[$x] . '" id="' . $fields[$x] . '" class="custom-select" style="width: 100%">
					<option value="1">True</option>
					<option value="0">False</option>
				</select>
			</div>';
		}
	}
?>
							</div>
							<button type="submit" class="btn btn-primary"><?= $lang['add']; ?></button>
						</form>
					</div>
				</div>
			</div>
	  </div>
<script type="text/javascript">
$(document).ready(function () {
    $('.table').DataTable();
    $('.table').parent().addClass('table-responsive');
});
function delete_value(id, token) {
    if (window.XMLHttpRequest) {
        xmlhttp = new XMLHttpRequest();
    } else {
        xmlhttp = new ActiveXObject("Microsoft.XMLHTTP");
    }
    var url = "ajax.php?action=deleteValue&id=" + id + "&token=" + token;

    xmlhttp.open("GET", url, true);
    xmlhttp.onreadystatechange = function() {
        if (this.readyState == 4 && this.status == 200) {
            document.getElementById("message").style.display = "block";
            if (xmlhttp.responseText == true) {
                document.getElementById("alert").className = "alert alert-success alert-dismissible fade show";
                document.getElementById("alert").innerHTML = "<?= $lang['delete_value_success']; ?>";
                var row = document.getElementById("row_" + id);
                row.parentNode.removeChild(row);
            } else {
                document.getElementById("alert").className = "alert alert-danger alert-dismissible fade show";
                document.getElementById("alert").innerHTML = "<?= $lang['delete_value_failed']; ?>";
            }
            setTimeout(function() {
                $('#message').fadeOut('slow');
            }, 3000);
        }
    };
    xmlhttp.send();
}
</script>
<?php include_once('footer.php'); ?>